#include <unistd.h>
//int pipe2(int pipefd[2], int flags);
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/select.h>
#include <time.h>
#include <fcntl.h>
#include <errno.h>
#include <math.h>

#include "SDL.h"
#include "SDL_image.h"

#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<(b)?(a):(b))
#define fabs(x) fabs(x)
#define iabs(x) abs(x)
#define sgn(x) (((x)>0)-((x)<0))
#define div1(a,b) (a+(b-1))/(b)
#define ang_i(x) ang((x)/(double)100.0)
#define ang(x) ((x)*(2*M_PI/3.6))
#define dang(x) ((x)*(3.6/(2*M_PI)))

char check_fd(int fd)
{	fd_set fds_r,fds_e;FD_ZERO(&fds_r);FD_ZERO(&fds_e);
	FD_SET(fd,&fds_r);FD_SET(fd,&fds_e);
	struct timeval tv;tv.tv_sec=0;tv.tv_usec=/*20000*/0;
	int res=select(fd+1,&fds_r,NULL,&fds_e,&tv);if(res<0)/*perror("select")*/;
	return (res>0)
;
}SDL_Window *window;
SDL_Renderer *renderer
;
char app_done=0,redraw=0,refresh=0;char pr_flag;char show_grid=0,show_targ1=1
;
int fzoom=100 ;//100px shall be drawn as fzoom;
SDL_Rect win_coord[2];signed char win_coord_n=0,coord_arg=0,win_coord_targ=0;
#define win_coord1 win_coord[coord_arg]
SDL_Rect win_abs ;//x,y is 0,0 always
;
#define fzoom1 (coord_arg==1?100:fzoom)
int absx1(int cx,unsigned char fact_1)
{	if(fact_1)return cx*fzoom1/100+div1(win_abs.w,2)+win_coord1.x;
	else return cx*fzoom1/100;
}int absy1(int cy,unsigned char fact_1)
{	if(fact_1)return cy*fzoom1/100+div1(win_abs.h,2)+win_coord1.y;
	else return cy*fzoom1/100;
}int coordx1(int abx,unsigned char fact_1)
{	if(fact_1)return (abx-div1(win_abs.w,2)-win_coord1.x)*100/fzoom1;
	else return (abx)*100/fzoom1;
}int coordy1(int aby,unsigned char fact_1)
{	if(fact_1)return (aby-div1(win_abs.h,2)-win_coord1.y)*100/fzoom1;
	else return (aby)*100/fzoom1
;
}void* sdl_v;
#define sdl_(c,b,a,...) ({sdl_v=(void *)c##a(__VA_ARGS__);if((b>0&&sdl_v==NULL)||(b<=0&&((long)sdl_v)<b)){printf("SDL_%s failed: %s\n",#a, SDL_GetError());}sdl_v;})
#define sdl(b,a,...) sdl_(SDL_,b,a,__VA_ARGS__)

#define set_rect(r,x1,y1,w1,h1) (r).x=x1;(r).y=y1;(r).w=w1;(r).h=h1
#define rect_arg(r) (r).x,(r).y,(r).w,(r).h
#define check_rect(rx,ry,rw,rh,x,y) (((rx)<(x)&&(x)<(rx)+(rw))&&((ry)<(y)&&(y)<(ry)+(rh)))

SDL_Rect *sdl_clip_maybe(SDL_Rect *asrc,SDL_Rect *adest,char do_it)
{	if(do_it){if(fzoom>100);else do_it=0;};
	if(do_it);else return adest ;int one_pix;one_pix=absx1(1,0);
	SDL_Rect win;if(0)
{		set_rect(win,absx1(coordx1(100,1),1),absy1(coordy1(100,1),1),absx1(coordx1(win_abs.w-200,0),0),absy1(coordy1(win_abs.h-200,0),0));
}	else if(0)
{		set_rect(win,absx1(coordx1(-10,1),1),absy1(coordy1(-10,1),1),absx1(coordx1(win_abs.w+20,0),0),absy1(coordy1(win_abs.h+20,0),0));
}	else
{		set_rect(win,absx1(coordx1(one_pix,1),1),absy1(coordy1(one_pix,1),1),absx1(coordx1(win_abs.w-win.x,0),0),absy1(coordy1(win_abs.h-win.y,0),0));
}	win.w+=win.x;win.h+=win.y;
	asrc->w+=asrc->x;asrc->h+=asrc->y ;adest->w+=adest->x;adest->h+=adest->y;
	SDL_Rect src=*asrc;SDL_Rect dest=*adest;
	if(src.w-src.x==coordx1(dest.w-dest.x+one_pix/2,0))/*if scale is one*/;else goto skip1;
	if(adest->x<win.x)
{		asrc->x=src.x+coordx1(win.x-dest.x+one_pix/2,0);
		adest->x=win.x;
}	if(adest->w>win.w)
{		asrc->w=src.w-coordx1(dest.w-win.w+one_pix/2,0);
		adest->w=win.w;
}	one_pix=absy1(1,0);
	if(adest->y<win.y)
{		asrc->y=src.y+coordy1(win.y-dest.y+one_pix/2,0);
		adest->y=win.y;
}	if(adest->h>win.h)
{		asrc->h=src.h-coordy1(dest.h-win.h+one_pix/2,0);
		adest->h=win.h;
}	one_pix=absx1(1,0);
	if(src.w-src.x==coordx1(dest.w-dest.x+one_pix/2,0));else if(fzoom>=200)
{		static int pr;if(pr<30)
{			pr+=1;dprintf(2,"error width mismatch: %d %d %d\n",src.w-src.x,coordx1(dest.w-dest.x+one_pix/2,0),fzoom);
}}	skip1:;asrc->w-=asrc->x;asrc->h-=asrc->y ;adest->w-=adest->x;adest->h-=adest->y;
	return adest/*&asrc*/
;}
#define dline1(a,b,c,d) sdl(0,RenderDrawLine,renderer,a,c,b,d)
//#define dline(a,b,c,d) dline1(absx1(a,1),absx1(b,1),absy1(c,1),absy1(d,1));
void dline(int a,int b,int c,int d)
{	int a1=absx1(a,1),b1=absx1(b,1),c1=absy1(c,1),d1=absy1(d,1),tmp;
	if(iabs(a-b)<=iabs(c-d))
{		if(c1<d1){tmp=absy1(d+1,1);if(tmp>d1)d1=tmp-1;}else {tmp=absy1(c+1,1);if(tmp>c1)c1=tmp-1;};
		int a2=absx1(a+1,1),b2=absx1(b+1,1);while(1)
{			dline1(a1,b1,c1,d1);a1+=1;b1+=1;if(a1<a2||b1<b2);else break;
}}	else
{		if(a1<b1){tmp=absx1(b+1,1);if(tmp>b1)b1=tmp-1;}else {tmp=absx1(a+1,1);if(tmp>a1)a1=tmp-1;};
		int c2=absy1(c+1,1),d2=absy1(d+1,1);while(1)
{			dline1(a1,b1,c1,d1);c1+=1;d1+=1;if(c1<c2||d1<d2);else break;
}}}void thick_line(int x1,int x2,int y1,int y2,int thn/*usually odd*/)
{	int n;if(thn) dline(x1,x2,y1,y2);
	if(iabs(x1-x2)<=iabs(y1-y2))
{		for(n=1;n<=thn/2;n+=1)
{			dline(x1+n,x2+n,y1,y2) ;dline(x1-n,x2-n,y1,y2);
}}	else
{		for(n=1;n<=thn/2;n+=1)
{			dline(x1,x2,y1+n,y2+n) ;dline(x1,x2,y1-n,y2-n)
;
}}}struct file_xfo
{	char type2;unsigned int color;signed char thn;char edge;
	int sides;int rot;
};//;
struct file
{	char *fn;char type1;SDL_Texture* textu;SDL_Surface *surf;char *surf_a;
	struct file_xfo *xfo;
	int b_x,b_y;
};//;
void file_init(struct file *file)
{	file->type1=0;file->textu=NULL;file->xfo=NULL;
}struct file *file_arr;int len_file_arr;
int file_n;SDL_Rect dest_bound,bound1;signed char bound1_targ;
struct area_xfo
{	int angle/*deg*100*/;int rot_x,rot_y;signed char flip/*0 none 1 horiz. 2 vert.*/;
};//;
struct area_xfo2 {int src_w,src_h ;};
struct area
{	int off;
	//int b_x,b_y;
	int x,y,w,h,dest_x,dest_y;char *id;int file_n;
	struct area_xfo *xfo;struct area_xfo2 *xfo2;
	char del/*0 deleted 1-9 layer (0..4,-4..-1)*/;char screen_targ;char hit;
};//;
void area_init(struct area *area)
{	area->del=1;area->screen_targ=win_coord_targ;area->file_n=file_n;area->xfo=NULL;area->xfo2=NULL;
}struct area *area_arr;int len_area_arr,len_area_arr_2;int area_arr_n=-1;
#define file1_set_mac(fn,b_x,b_y) ({char *a1=fn;int a2=b_x;int a3=b_y;file1_set(a1,a2,a3,0);})
void file1_set(char *fn,int b_x,int b_y,int off/*usually zero0*/)
{	if(b_x||b_y)
{		dprintf(2,"error: b_x and b_y must be zero\n");return;
}	int n=off;while(n<len_file_arr)
{		if(!strcmp(file_arr[n].fn,fn))break;n+=1;
}	struct file *file1=(file_arr&&len_file_arr)?&file_arr[n]:NULL;
	if(redraw==2)redraw=0;
	if(n>=len_file_arr)
{		if(pr_flag>=2)dprintf(2,"eng new file %d\n",len_file_arr);
		len_file_arr+=1;file_arr=realloc(file_arr,sizeof(struct file)*len_file_arr);
		file1=&file_arr[n];file_init(file1);
		file1->fn=strdup(fn);if(!strncmp(fn,"stream:",7))file1->type1=1;
		else if(!strncmp(fn,"mark:",5))file1->type1=2;
		file1->b_x=b_x;file1->b_y=b_y;
}	else if(file1->b_x!=b_x||file1->b_y!=b_y)
{		file1->b_x=b_x;file1->b_y=b_y;redraw=1;
}	if(!file1->textu&&file1->type1==0)
{		SDL_Surface *tmp;
		tmp=sdl_(IMG_,1,Load,file1->fn);if(tmp)
{			file1->textu=sdl(1,CreateTextureFromSurface,renderer,tmp);
			file1->surf=tmp;file1->surf_a=NULL;//SDL_FreeSurface(tmp);
			//SDL_DestroyTexture(file1->textu);
			if(pr_flag>=1)dprintf(2,"loaded %s\n",fn);
}}	file_n=n;
}void draw_all(char use_surf);void script2(int xx,int yy);
void file2_save(char *fn)
{	SDL_Renderer *renderer_bak=renderer;char show_grid_bak=show_grid,show_targ1_bak=show_targ1;
	int fzoom_bak=fzoom;fzoom=100 ;coord_arg=0;
	SDL_Rect win_coord1_bak=win_coord1;
	SDL_Surface *surf=sdl(1,CreateRGBSurface,0,dest_bound.w,dest_bound.h,32,255<<8*2,255<<8*1,255<<8*0,255<<8*3/*a*/);if(surf)
{		renderer=sdl(1,CreateSoftwareRenderer,surf);if(renderer)
{			SDL_SetRenderDrawBlendMode(renderer,SDL_BLENDMODE_BLEND);
			signed char targ=win_coord_n;win_coord_n=0;
			script2(0,0);win_coord_n=targ;win_coord1.x=-dest_bound.x-win_abs.w/2;win_coord1.y=-dest_bound.y-win_abs.h/2;
			draw_all(1);SDL_RenderPresent(renderer);
			dprintf(2,"writing %s\n",fn);
			sdl_(IMG_,0,SavePNG,surf,fn);
			SDL_DestroyRenderer(renderer);
}		SDL_FreeSurface(surf);
}	renderer=renderer_bak;show_grid=show_grid_bak;show_targ1=show_targ1_bak;fzoom=fzoom_bak;coord_arg=0;win_coord1=win_coord1_bak;
}//;
#define map_add_area_mac(x,y,w,h,dest_x,dest_y,id) ({int a1=x;int a2=y;int a3=w;int a4=h;int a5=dest_x;int a6=dest_y;char *a7=id;map_add_area(a1,a2,a3,a4,a5,a6,a7);})
void map_add_area(int x,int y,int w,int h,int dest_x,int dest_y,char *id)
{	int n=0,n_out=-1;while(n<len_area_arr_2)
{		struct area *area1=&area_arr[n];
		if(area1->del==0){n_out=n;break;}n+=1;
}	if(n_out<0)
{		n_out=len_area_arr_2;
		len_area_arr_2+=1;if(len_area_arr_2<0)
{			dprintf(2,"areas in excess\n");len_area_arr_2-=1;area_arr_n=-1;return;
}		area_arr=realloc(area_arr,sizeof(struct area)*len_area_arr_2);
}	struct area *area1=&area_arr[n_out];area_init(area1);
	area1->x=x;area1->y=y;area1->w=w;area1->h=h;area1->dest_x=dest_x;area1->dest_y=dest_y;area1->id=id[0]=='\0'?NULL:strdup(id);
	area_arr_n=n_out;}
#define map_add_area2_mac(aa,rot_x,rot_y,flip) ({int a1=aa;int a2=rot_x;int a3=rot_y;signed char a4=flip;map_add_area2(a1,a2,a3,a4);})
void map_add_area2(int aa,int rot_x,int rot_y,signed char flip)
{	if(area_arr_n<0)return;
	struct area *area1=&area_arr[area_arr_n];
	if(!area1->xfo)area1->xfo=malloc(sizeof(struct area_xfo));
	area1->xfo->angle=aa;area1->xfo->rot_x=rot_x;area1->xfo->rot_y=rot_y;area1->xfo->flip=flip;}
#define map_add_area3_mac(w,h) ({int a1=w;int a2=h;map_add_area3(a1,a2);})
void map_add_area3(int w,int h)
{	if(area_arr_n<0)return;
	struct area *area1=&area_arr[area_arr_n];
	if(!area1->xfo2)area1->xfo2=malloc(sizeof(struct area_xfo2));
	area1->xfo2->src_w=w;area1->xfo2->src_h=h;
}void map_move_area(char layer/*1-9*/)
{	int n=area_arr_n;
	if(n>=0)
{		struct area *area1=&area_arr[n];
		if(area1->del!=0)area1->del=layer;
}}void map_clear_area()
{	int n=0;while(n<len_area_arr)
{		struct area *area1=&area_arr[area_arr[n].off];
		if(area1->del!=0)
{			free(area1->id);free(area1->xfo);free(area1->xfo2);area1->del=0;
}		n+=1;
}}void map_list_area()
{	len_area_arr=0;
	signed char targ=-1;while(targ<=1)
{		targ+=1;
		int n_2=-4;while(1)
{			char flag1=0;
			int n=0;while(n<len_area_arr_2)
{				struct area *area1=&area_arr[n];
				if(area1->del!=0&&area1->screen_targ==targ)
{					int var=area1->del-0;if(var>4)var-=9;
					if(var>n_2)flag1=1;else if(var==n_2)
{						struct area *area2=&area_arr[len_area_arr];
						area2->off=n;len_area_arr+=1;
}}				n+=1;
}			if(flag1)n_2+=1;else break
;
}}}int bg_color=0xFFFFFF,mg_color=0x333333,fg_color=0x000000;
void set_color(int off,int c)
{	if(off==0)bg_color=c;else if(off==1)mg_color=c;else if(off==2)fg_color=c;else dprintf(2,"invalid color off %d\n",off);
}//;
#define sdl_set_color(renderer,color) SDL_SetRenderDrawColor(renderer,(color>>8*2)&0xFF,(color>>8*1)&0xFF,(color>>8*0)&0xFF,/*a*/0xFF-((color>>8*3)&0xFF))
void draw_all(char use_surf)
{	//SDL_RenderClear(renderer);
	sdl_set_color(renderer,bg_color);SDL_RenderFillRect(renderer,NULL);
	SDL_Rect src;SDL_Rect dest;
	int n=0;while(n<len_area_arr)
{		struct area *area1=&area_arr[area_arr[n].off];coord_arg=area1->screen_targ;if(coord_arg==1&&show_targ1==0)goto cont1;
		struct file *file1=&file_arr[area1->file_n];
		src.x=file1->b_x+area1->x;src.y=file1->b_y+area1->y;src.w=area1->w;src.h=area1->h;if(area1->xfo2)
{			src.w=area1->xfo2->src_w;src.h=area1->xfo2->src_h;
}		dest.x=absx1(area1->dest_x,1);dest.y=absy1(area1->dest_y,1);dest.w=absx1(area1->w,0);dest.h=absy1(area1->h,0);
		if(file1->type1!=2)
{			//dprintf(2,"src %d %d %d %d\n",rect_arg(src));
			//dprintf(2,"dest %d %d %d %d\n",rect_arg(dest));
			SDL_Texture *tmp2=file1->textu;if(use_surf)
{				tmp2=sdl(1,CreateTextureFromSurface,renderer,file1->surf);
}			if(tmp2)
{				if(area1->xfo)
{					double angle=((double)area1->xfo->angle)/100;
					SDL_Point rot;rot.x=absx1(area1->xfo->rot_x,1)-dest.x;rot.y=absy1(area1->xfo->rot_y,1)-dest.y;
					SDL_RenderCopyEx(renderer,tmp2,&src,&dest,0-angle,&rot,(SDL_RendererFlip)area1->xfo->flip);
}				else SDL_RenderCopy(renderer,tmp2,&src,sdl_clip_maybe(&src,&dest,1));
				//else SDL_RenderCopyEx(renderer,tmp2,&src,&dest,-30,NULL,SDL_FLIP_NONE);
				if(use_surf)SDL_DestroyTexture(tmp2);
}			else{sdl_set_color(renderer,mg_color);SDL_RenderFillRect(renderer,&dest);};
}		else if(file1->xfo->type2==1)
{			sdl_set_color(renderer,file1->xfo->color);
			int x=area1->dest_x,x2=area1->dest_x+area1->w;
			int y=area1->dest_y,y2=area1->dest_y+area1->h;
			thick_line(x,x2,y,y,file1->xfo->thn);
			thick_line(x2,x2,y,y2,file1->xfo->thn);
			thick_line(x2,x,y2,y2,file1->xfo->thn);
			thick_line(x,x,y2,y,file1->xfo->thn);if(file1->xfo->edge)
{				sdl_set_color(renderer,~file1->xfo->color);
				int thn_2=file1->xfo->thn/2;if(thn_2<1)thn_2=1;
				x+=thn_2;x2-=thn_2;y+=thn_2;y2-=thn_2;
				thick_line(x,x2,y,y,thn_2);
				thick_line(x2,x2,y,y2,thn_2);
				thick_line(x2,x,y2,y2,thn_2);
				thick_line(x,x,y2,y,thn_2);
}}		else if(file1->xfo->type2==2)
{			SDL_Rect dest;if(file1->xfo->edge)
{				int thn_2=absx1(1,0);if(thn_2<1)thn_2=1;
				set_rect(dest,absx1(area1->dest_x,1),absy1(area1->dest_y,1),absx1(file1->xfo->thn,0)+thn_2,absy1(file1->xfo->thn,0)+thn_2);
				sdl_set_color(renderer,~file1->xfo->color);
				SDL_RenderFillRect(renderer,&dest);
				dest.w-=thn_2;dest.h-=thn_2;
}			else set_rect(dest,absx1(area1->dest_x,1),absy1(area1->dest_y,1),absx1(file1->xfo->thn,0),absy1(file1->xfo->thn,0));
			sdl_set_color(renderer,file1->xfo->color);
			SDL_RenderFillRect(renderer,&dest);
}		else if(file1->xfo->type2==3)
{			SDL_Rect dest;if(!file1->xfo->edge)
{				set_rect(dest,absx1(area1->dest_x,1),absy1(area1->dest_y,1),absx1(area1->w,0),absy1(area1->h,0));
				sdl_set_color(renderer,file1->xfo->color);
				SDL_RenderFillRect(renderer,&dest);
}}		else if(file1->xfo->type2==4)
{			sdl_set_color(renderer,file1->xfo->color);
			int r=(area1->w+area1->h)/2/2,r_2=r/2;
			int x=area1->dest_x+area1->w/2;
			int y=area1->dest_y+area1->h/2;
			int p[8];char p_set=0;
			int a=0,step=360/file1->xfo->sides,rot=90,rot2=rot+step/2;
			//if(360%file1->xfo->sides)dprintf(2,"error: check side count\n");
			while(a<=360)
{				p[0]=x+r*cos(ang_i(rot+a));p[1]=y-r*sin(ang_i(rot+a));
				p[2]=x+r_2*cos(ang_i(rot2+a));p[3]=y-r_2*sin(ang_i(rot2+a));
				thick_line(p[0],p[2],p[1],p[3],file1->xfo->thn);
				if(p_set)thick_line(p[4],p[0],p[5],p[1],file1->xfo->thn);else
{					p_set=1;p[6]=p[0];p[7]=p[1];
}				p[4]=p[2];p[5]=p[3];
				a+=step;
}			if(p_set)thick_line(p[2],p[6],p[3],p[7],file1->xfo->thn);
}		else if(file1->xfo->type2==5)/*none*/;
		cont1:;n+=1;
}	if(show_grid)
{		sdl_set_color(renderer,fg_color) ;coord_arg=0;
		int y,y_1=coordy1(0,1),y_2=coordy1(win_abs.h,1);while(y_1<=y_2)
{			y=absy1(y_1,1);dline1(0,win_abs.w,y,y);y_1+=1;
}		int x,x_1=coordx1(0,1),x_2=coordx1(win_abs.w,1);while(x_1<=x_2)
{			x=absx1(x_1,1);dline1(x,x,0,win_abs.h);x_1+=1;
}}}void script2_(int xx,int yy);
void script2(int xx,int yy)
{	char test1=(!xx&&!yy);
	if(test1&&bound1_targ)coord_arg=bound1_targ;
	else coord_arg=win_coord_n;script2_(xx,yy);
	if(coord_arg==1){coord_arg-=1;script2_(xx,yy);};
}void script2_(int xx,int yy)
{	char test1=(!xx&&!yy);
	static int ww,hh;SDL_GetWindowSize(window,&ww,&hh);
	//if(ww!=win_abs.w||hh!=win_abs.h);
	win_abs.w=ww;win_abs.h=hh;
	xx=-xx ;yy=-yy;
	xx+=win_coord1.x ;yy+=win_coord1.y;
	set_rect(win_coord1,xx,yy,coordx1(ww,0),coordy1(hh,0))
;
	if(test1);else {redraw=1;return;};
	SDL_Rect bound;set_rect(bound,0,0,0,0);unsigned int total_a=0;
	int n=0;while(n<len_area_arr)
{		struct area *area1=&area_arr[area_arr[n].off];if(area1->screen_targ==coord_arg)
{			if(total_a<1||area1->dest_x<bound.x)bound.x=area1->dest_x;
			if(total_a<1||area1->dest_y<bound.y)bound.y=area1->dest_y;
			if(total_a<1||area1->dest_x+area1->w>bound.w)bound.w=area1->dest_x+area1->w;
			if(total_a<1||area1->dest_y+area1->h>bound.h)bound.h=area1->dest_y+area1->h;
			n+=1;total_a+=1;
}		else n+=1;
}	bound.w-=bound.x;bound.h-=bound.y;
	if(coord_arg==0)dest_bound=bound
;
	SDL_Rect w;
	set_rect(w,coordx1(0,1),coordy1(0,1),win_coord1.w,win_coord1.h);
	if(pr_flag>=3)
{		dprintf(2,"dest_bound %d %d %d %d ,%d\n",rect_arg(dest_bound),total_a);
		dprintf(2,"w %d %d %d %d\n",rect_arg(w));
}	if((coord_arg==0||bound1_targ==1)&&bound1.w!=0)
{		if(w.x-bound1.x>0)win_coord1.x+=absx1(w.x-bound1.x,0);
		if(w.x+w.w-(bound1.x+bound1.w)<0)win_coord1.x+=absx1(w.x+w.w-(bound1.x+bound1.w),0) ;if(coord_arg==0)bound1.w=0;
}	if((coord_arg==0||bound1_targ==1)&&bound1.h!=0)
{		if(w.y-bound1.y>0)win_coord1.y+=absy1(w.y-bound1.y,0);
		if(w.y+w.h-(bound1.y+bound1.h)<0)win_coord1.y+=absy1(w.y+w.h-(bound1.y+bound1.h),0) ;if(coord_arg==0){bound1.h=0;bound1_targ=0;};
}	if(total_a>0)
{		if(w.x+w.w-bound.x<0)win_coord1.x+=absx1(w.x+w.w-bound.x,0);
		if(w.x-(bound.x+bound.w)>0)win_coord1.x+=absx1(w.x-(bound.x+bound.w),0);
		if(w.y+w.h-bound.y<0)win_coord1.y+=absy1(w.y+w.h-bound.y,0);
		if(w.y-(bound.y+bound.h)>0)win_coord1.y+=absy1(w.y-(bound.y+bound.h),0);
}}void scroll_f(SDL_Rect b1)
{	//dprintf(2,"b1 %d %d %d %d\n",rect_arg(b1));
	//script1(-b1.w,-b1.h);
	script2(-b1.w,-b1.h)
;
}int main_argc;char **main_argv;
int fdin=-1,fd=-1;
char read_1()
{	char out;while(1)
{		ssize_t s2=read(fdin,&out,1);if(s2<0);else if(s2==0)break;else break;
}	return out;
}int read_int()
{	char buf[sizeof(int)];int sz_buf=sizeof(int);int len_buf=0;
	while(1)
{		ssize_t s1=read(fdin,buf+len_buf,sz_buf-len_buf);if(s1<0);
		else if(s1==0)break;
		else
{			len_buf+=s1;if(len_buf>=sz_buf)break;
}}	int *out=(int *)buf;
	if(pr_flag>=3)dprintf(2,"recv %d\n",out[0]);return out[0];
}char *read_str()
{	static char buf[512];int sz_buf=512;int len_buf=0;char end=0;
	while(1)
{		int len2=8-len_buf%8;if(len2==8&&end)break;
		ssize_t s1=read(fdin,buf+len_buf,min(len2,sz_buf-0-len_buf));if(s1<0);
		else if(s1==0){buf[len_buf]='\0';break;}
		else
{			//len_buf+=s1;
			ssize_t s2=0;while(s2<s1)
{				char c=buf[len_buf+s2];
				if(c=='\r'||c=='\n')
{					buf[len_buf+s2]='\0';end=1;
}				s2+=1;
}			len_buf+=s1;
			if(len_buf>=sz_buf-0)len_buf=0;
}}	if(pr_flag>=3)dprintf(2,"recv %s\n",buf);return buf;
}void write_1(char val)
{	ssize_t s1=write(fd,&val,1);
}void write_int(int val)
{	ssize_t s1=write(fd,&val,sizeof(int));
	if(pr_flag>=3)dprintf(2,"sent %d\n",val);
}void write_str(char *str)
{	char *str1=str,*str_f=NULL,*res;
	int off=0,len_str=strlen(str);
	while(1)
{		res=strchr(str,'\n');if(!res)break;
		if(!str_f){str_f=str=strdup(str);res=strchr(str,'\n');}res[0]=' ';
}	while(off<len_str)
{		ssize_t s1=write(fd,str+off,min(64,len_str-off));if(s1<0);
		else if(s1==0);
		else
{			off+=s1;
}}	if(1)
{		write(fd,"\n",1);int len2=(8-(len_str+1)%8)%8;if(len2)
{			char *a=malloc(sizeof(char)*len2);memset(a,' ',len2);write(fd,a,len2);free(a);
}}	if(pr_flag>=3)dprintf(2,"sent %s\n",str);free(str_f);
}char builtin_key=1;signed char scroll_e=-1,scroll_a;
void setup_comm(char arg)
{	static pid_t ev_pid=0;static int pipefd[2],pipefdin[2];int res,ex;
	if(ev_pid&&(arg>>1)==1)
{		kill(ev_pid,SIGTERM);if(pr_flag>=1)dprintf(2,"\nending");
}	if(ev_pid&&waitpid(ev_pid,&ex,((arg>>1)==1)?0:WNOHANG)>0&&kill(ev_pid,0)==-1)
{		close(pipefd[1]);fd=-1;close(pipefdin[0]);fdin=-1;ev_pid=0;
}	if(arg==3)return;if(ev_pid==0)
{		res=pipe(pipefd);res=pipe(pipefdin);
		//res=pipe2(pipefdin,O_NONBLOCK);
		//long flags=fcntl(F_GETFL,pipefdin[0]);if(flags!=-1)res=fcntl(F_SETFL,pipefdin[0],flags|O_NONBLOCK);if(flags==-1||res==-1)dprintf(2,"fl. err\n");
		ev_pid=fork();
		if(ev_pid==(pid_t)-1)
{			close(pipefd[0]);close(pipefd[1]);
			close(pipefdin[0]);close(pipefdin[1]);ev_pid=0;
}		else if(!ev_pid)
{			close(pipefd[1]);dup2(pipefd[0],0);
			close(pipefdin[0]);dup2(pipefdin[1],1);
			SDL_Quit();
			if(1<main_argc&&execvp((main_argv+1)[0],main_argv+1)==-1)
{				dprintf(2,"exec %s\n",strerror(errno));
}			_Exit(1);
}		else
{			if(pr_flag>=1)dprintf(2,"\nlaunching\n");
			close(pipefd[0]);fd=pipefd[1];
			close(pipefdin[1]);fdin=pipefdin[0];if(arg!=0)
{				builtin_key=1;scroll_e=-1;win_coord_n=0;
}			if(fd>=0)
{				char cmd[]={1,arg};write(fd,cmd,2)
;
}}}}void file1_info()
{	struct file *file1=&file_arr[file_n];int w=0,h=0;//Uint32 *format;int *access;
	if(file1->textu)
{		if(!SDL_QueryTexture(file1->textu,NULL,NULL,&w,&h));
}	setup_comm(1);if(fd>=0)
{		write_1(9);write_int(w-file1->b_x);write_int(h-file1->b_y);
}}void file1_reload()
{	struct file *file1=&file_arr[file_n];
	char test1=!file1->textu;if(file1->textu)
{		SDL_FreeSurface(file1->surf);free(file1->surf_a);
		SDL_DestroyTexture(file1->textu);file1->textu=NULL;
}	if(file1->type1==0)
{		file1_set(file1->fn,0,0,file_n);
}	else if(file1->type1==1)
{		char type2=read_1()/*0 png or bmp 1 raw*/;
		if(type2==0);
		else if(type2==1)
{			int w,h,bypr;char *buf;
			w=read_int();h=read_int();bypr=read_int();
			//if(pr_flag>=2)dprintf(2,"eng surf %X %X %X\n",bypr,h,bypr*h);
			size_t s,s2;ssize_t s1;
			s=0;s2=bypr*h;buf=malloc(s2);if(!buf)
{				dprintf(2,"error: %s\n","ENOMEM");app_done=1;
}			else
{				while(s<s2)
{					s1=read(fdin,buf+s,s2-s);if(s1<0);
					else if(s1==0)break;
					else s+=s1;
}				file1->surf=sdl(1,CreateRGBSurfaceFrom,buf,w,h,32,bypr/*p*/,0xFF<<8*2,0xFF<<8*1,0xFF,0xFF<<8*3/*A*/);/*free(buf);*/file1->surf_a=buf;if(file1->surf)
{					file1->textu=sdl(1,CreateTextureFromSurface,renderer,file1->surf);
					if(test1&&pr_flag>=1)dprintf(2,"loaded %s\n",file1->fn);
					if(file1->textu);else
{						SDL_FreeSurface(file1->surf);free(file1->surf_a);
}}				else free(file1->surf_a);
}}}	else
{		if(!file1->xfo)file1->xfo=malloc(sizeof(struct file_xfo));
		char type2=read_1();file1->xfo->type2=type2;if(type2==1||type2==2||type2==3||type2==4)
{			file1->xfo->color=read_int();file1->xfo->thn=read_1();file1->xfo->edge=read_1();
}		if(type2==4)
{			file1->xfo->sides=(int)(unsigned char)read_1();file1->xfo->rot=read_int();}}}
#define main_win_mac(w,h,op) ({int a1=w;int a2=h;main_win(a1,a2,op);})
void main_win(int w,int h,char op);
#define main_win_wr(fn) int fd=open(fn,O_WRONLY|O_CREAT|O_TRUNC);if(fd>=0){dprintf(2,"writing window size to %s\n",fn);dprintf(fd,"%dx%d",win_abs.w,win_abs.h);close(fd);}
char flag_2=0;unsigned char input_mask=0;
char check_comm()
{	if(flag_2)return 0;
	if(fdin>=0);else return 0;
	static char mod_mode;
	if(check_fd(fdin));else
{		if(mod_mode)/*dprintf(2,"check_fd\n");*/return 1;return 0;
}	char cmd;ssize_t s1=read(fdin,&cmd,1);if(s1<0)/*dprintf(2,"check_comm read err.\n")*/;
	else if(s1==0);
	else
{		if(pr_flag>=3)dprintf(2,"got %d\n",cmd);
		if(!redraw)redraw=2;
		if(cmd==1)file1_set_mac(read_str(),read_int(),read_int());
		else if(cmd==2)map_add_area_mac(read_int(),read_int(),read_int(),read_int(),read_int(),read_int(),read_str());
		else if(cmd==3)
{			/*0 clear_area,begin mod. 1 end mod.,screen refresh;
			2 move_area(2) 3 ignored 4 begin mod. 5 del 6-14 move_area(1-9) 15-16 screen_targ 17-18 set screen_n 19 get screen_n */;
			char op=read_1();if(op==0||op==4)mod_mode=1;char test1=0;
			if(op==0)map_clear_area();
			else if(op==2)map_move_area(2);
			else if(op==5);
			else if(6<=op&&op<=14){map_move_area(op-5);test1=1;}
			else if(op==15||op==16)win_coord_targ=(op==16);
			if(op==0||op==2||op==5||test1);else if(redraw==2)redraw=0;
			if(op==1)
{				map_list_area();mod_mode=0;return 0/*screen refresh*/;
}}		else if(cmd==4)
{			unsigned char off=read_1();set_color(off,read_int());
}		else if(cmd==5)/*ignore*/;
		else if(cmd==6)/*received tick*/
{			write_1(6)/*send tick*/;if(redraw==2)redraw=0;
}		else if(cmd==7)
{			input_mask=read_1()/*bit v8 send mouse button v4 send mouse key mod int v2 send mouse button-up/down v1 send key-up/down, appends char/int to cmd=4,cmd=4,cmd=4,cmd=3*//*bit v128 read another byte v64 report incoming dr. events,cmd=5 v32 send end of cmd=2 as cmd=7 v16 send mod detail*/;
}		else if(cmd==8/*bound1*/)
{			bound1.x=read_int();bound1.y=read_int();bound1.w=read_int();bound1.h=read_int();bound1_targ=win_coord_targ;
}		else if(cmd==9)file1_info();
		else if(cmd==10)map_add_area2_mac(read_int(),read_int(),read_int(),read_1());
		else if(cmd==11)map_add_area3_mac(read_int(),read_int());
		else if(cmd==12)file2_save(read_str());
		else if(cmd==13){file1_reload();redraw=1;}
		else if(cmd==14)/*none*/;
		else if(cmd==15)builtin_key=read_1();
		else if(cmd==16)
{			char op=read_1();if(op==0||op==2)main_win_mac(read_int(),read_int(),op);
			else if(op==1){char *fn=read_str();main_win_wr(fn);};
}		else if(cmd==17)scroll_a=read_1();
		//if(cmd==2)flag_2=1;
		if(redraw==2)redraw=1;if(app_done)return 0;else return 1;
}	return mod_mode
;
}//#define mod_weight(mod) (((mod)|(((mod)&KMOD_CTRL_R)?KMOD_CTRL_L:0)|(((mod)&KMOD_ALT_R)?KMOD_gLT_L:0)|(((mod)&KMOD_SHIFT_R)?KMOD_SHIFT_L:0)|(((mod)&KMOD_GUI_R)?KMOD_GUI_L:0))&~(KMOD_CTRL_R|KMOD_ALT_R|KMOD_SHIFT_R|KMOD_GUI_R));
#define mod_weight(mod) (((mod)|(((mod)&KMOD_RCTRL)?KMOD_LCTRL:0)|(((mod)&KMOD_RALT)?KMOD_LALT:0)|(((mod)&KMOD_RSHIFT)?KMOD_LSHIFT:0)|(((mod)&KMOD_RGUI)?KMOD_LGUI:0))&~(KMOD_RCTRL|KMOD_RALT|KMOD_RSHIFT|KMOD_RGUI))
#define mod_check(mod,c,a,sh,s) ((c==2||!((mod)&KMOD_CTRL)==!c)&&(a==2||!((mod)&KMOD_ALT)==!a)&&(sh==2||!((mod)&KMOD_SHIFT)==!sh)&&(s==2||!((mod)&KMOD_GUI)==!s))
void comm_key(char cmd,int sym,int mod)
{	write(fd,&cmd,1);write_int(sym);write_int(mod_weight(mod));if(input_mask&16)write_int(mod);
}void comm_click(char cmd,char cmd_1,char cmd_2,int x1,int y1,char btn,int mod,char state)
{	int x[2],y[2];coord_arg=1;x[coord_arg]=coordx1(x1,1);y[coord_arg]=coordy1(y1,1);coord_arg-=1;x[coord_arg]=coordx1(x1,1);y[coord_arg]=coordy1(y1,1);
	//dprintf(2,"click %d %d %d %d\n",x1,y1,x[coord_arg],y[coord_arg]);
	if(input_mask&14)
{		write(fd,&cmd_1,1);write_int(x[coord_arg]);write_int(y[coord_arg]);
		if(input_mask&8)write_1(btn);if(input_mask&4)
{			write_int(mod_weight(mod));if(input_mask&16)write_int(mod);
}		if(input_mask&2)write_1(state);
}	if(state==0)
{		int count=0;int n=0;while(n<len_area_arr)
{			struct area *area1=&area_arr[area_arr[n].off];signed char targ=area1->screen_targ;
			if(area1->id&&(area1->hit=check_rect(area1->dest_x,area1->dest_y,area1->w,area1->h,x[targ],y[targ])))count+=1;
			n+=1;
}		int count_1=0;n=0;while(n<len_area_arr)
{			struct area *area1=&area_arr[area_arr[n].off];signed char targ=area1->screen_targ;
			if(area1->id&&area1->hit)
{				write(fd,&cmd,1);write_int(x[targ]-area1->dest_x);write_int(y[targ]-area1->dest_y);write_str(area1->id?area1->id:"") ;count_1+=1;
				if(input_mask&32)
{					if(count_1==1){if(count_1==count)write_1(3);else write_1(1);}else if(count_1==count)write_1(2);else write_1(0);
}}			n+=1;
}		if(count==0&&(input_mask&(14|32)))
{			write(fd,&cmd,1);write_int(/*-100*/0);write_int(/*-100*/0);write_str("");
			if(input_mask&32)write_1(4)
;
}}}//#include "windowevent.c";
void CheckBEvent(SDL_Event *ev);
char get_mouse2(int *xp,int *yp)
{	int x,y,x1,y1;x=y=x1=y1=0;int ww,wh;
	/*SDL_BUTTON(btn)*/;
	Uint32 btn=SDL_GetGlobalMouseState(&x,&y)/*GetMouseState relative to external window*/;
	SDL_Window *wnd=SDL_GetMouseFocus()/*didn't return external window*/;
	SDL_GetWindowPosition(wnd,&x1,&y1);SDL_GetWindowSize(wnd,&ww,&wh);
	/*if(1)SDL_SetWindowInputFocus(wnd)*/;
	*xp=x-x1;*yp=y-y1;
	char ret=0;if(btn&SDL_BUTTON_RMASK)ret=3;else if(btn&SDL_BUTTON_MMASK)ret=2;else if(btn&SDL_BUTTON_LMASK)ret=1;
	if(0<=*xp&&*xp<ww&&0<=*yp&&*yp<=wh);else ret=0;return ret;
}void CheckWEvent(const SDL_Event *ev)
{	if(ev->type==SDL_WINDOWEVENT);else return;
	if(ev->window.event==SDL_WINDOWEVENT_EXPOSED)
{		refresh=1;
}	else if(ev->window.event==SDL_WINDOWEVENT_RESIZED)
{		//resizef(ev->window.data1,ev->window.data2);
		redraw=1;
}	else if(ev->window.event==SDL_WINDOWEVENT_FOCUS_GAINED)
{		if(1/*sdl does not send the click that focuses a window?*/)
{			int x,y;char btn=get_mouse2(&x,&y);if(btn)
{				static SDL_Event ev2;
				ev2.button.button=btn;ev2.button.x=x;ev2.button.y=y;
				ev2.type=ev2.button.type=SDL_MOUSEBUTTONDOWN;CheckBEvent(&ev2);
				ev2.type=ev2.button.type=SDL_MOUSEBUTTONUP;CheckBEvent(&ev2);
}}}}void get_mouse1(int *xp,int *yp)
{	int x,y,x1,y1;x=y=x1=y1=0;
	/*SDL_BUTTON(btn)*/;
	Uint32 btn=SDL_GetGlobalMouseState(&x,&y)/*GetMouseState relative to external window*/;
	SDL_Window *wnd=SDL_GetMouseFocus()/*didn't return external window*/;
	SDL_GetWindowPosition(wnd,&x1,&y1);
	if(1)SDL_SetWindowInputFocus(wnd);
	*xp=x-x1;*yp=y-y1;
}void CheckDrEvent(const SDL_Event *ev)
{	/*SDL_EventState(SDL_DROPFILE,SDL_IGNORE);SDL_EventState(SDL_DROPTEXT,SDL_IGNORE)*/;
	char cmd[]={5,0};
	if(ev->type==SDL_DROPBEGIN)cmd[1]=1/*dprintf(2,"drop begin\n")*/;
	else if(ev->type==SDL_DROPCOMPLETE)cmd[1]=2/*dprintf(2,"drop end\n")*/;
	else if(ev->type==SDL_DROPFILE)cmd[1]=3;
	else if(ev->type==SDL_DROPTEXT)cmd[1]=4;
	if(cmd[1]&&(input_mask&64))
{		setup_comm(1);if(fd>=0)
{			write(fd,cmd,2);
}}	if(cmd[1]==3||cmd[1]==4)
{		if(cmd[1]==4)
{			char *a=ev->drop.file;int len=strlen(a);
			if(len>0&&a[len-1]==' '){len-=1;a[len]='\0';};
}		/*dprintf(2,"dropped %s\n",ev->drop.file)*/;
		if((input_mask&64)&&fd>=0)
{			write_str(ev->drop.file);int x,y;get_mouse1(&x,&y);
			write_int(coordx1(x,1));write_int(coordy1(y,1));
}		SDL_free(ev->drop.file);
		/*ev->drop.windowID*/;
}}int prev_x,prev_y;int scroll_x,scroll_y;
void CheckBEvent(SDL_Event *ev)
{	if(ev->type==SDL_MOUSEWHEEL)
{		SDL_MouseWheelEvent *info=&ev->wheel;
		/*info->y "positive away from the user" unless flipped*/;
		if(info->y)
{			int val[]={win_abs.w/2-scroll_x,win_abs.h/2-scroll_y};
			if(iabs(val[0])>iabs(val[1]))
{				if(iabs(val[0])-iabs(val[1])<iabs(val[1]))val[1]=((val[1]>0)-(val[1]<0))*iabs(val[0]);else val[1]=0;
}			else
{				if(iabs(val[1])-iabs(val[0])<iabs(val[0]))val[0]=((val[0]>0)-(val[0]<0))*iabs(val[1]);else val[0]=0;
}			if(scroll_a&&scroll_e!=-1)
{				int n=scroll_e,v=1;while(n){v*=10;n-=1;};
				if(val[0])val[0]=scroll_a*v*sgn(val[0]);
				if(val[1])val[1]=scroll_a*v*sgn(val[1]);
}			if(info->y>0)script2(val[0],val[1]);
			else script2(-val[0],-val[1]);
}}	if(ev->type==SDL_MOUSEBUTTONDOWN||ev->type==SDL_MOUSEBUTTONUP);else return;
	SDL_MouseButtonEvent *info=&ev->button;
	static int down;down=(info->type==SDL_MOUSEBUTTONDOWN);
	SDL_Keymod mod=SDL_GetModState();
	char test_1=0;if(info->button==SDL_BUTTON_LEFT)
{		//printf("%d down\n",down);
		if(mod&KMOD_CTRL)
{			static SDL_Rect b1;
			if(down){b1.x=info->x;b1.y=info->y;}
			else{b1.w=info->x-b1.x;b1.h=info->y-b1.y;
			static int ta,tb; ta=abs(b1.w)<30 ;tb=abs(b1.h)<30;
			if(ta&&!tb)b1.w=0;if(tb&&!ta)b1.h=0;
			if(b1.w||b1.h){scroll_f(b1);}};
}		else if(down)
{			setup_comm(1);if(fd>=0)
{				comm_click(2,4,7,info->x,info->y,1,mod,0);
}			prev_x=info->x;prev_y=info->y;
}		else test_1=1;
}	else test_1=1;if(test_1)
{		if(down||(input_mask&2))
{			setup_comm(1);if(fd>=0)
{				comm_click(2,4,7,info->x,info->y,(char)(unsigned char)info->button,mod,!down);
}}}	if(info->button==SDL_BUTTON_MIDDLE)
{		//if(down)actionf(info->x,info->y);
}}void CheckKEvent(SDL_Event *ev)
{	if(ev->type==SDL_KEYDOWN||ev->type==SDL_KEYUP);else return;
	SDL_KeyboardEvent *info=&ev->key;
	static int down;down=(info->type==SDL_KEYDOWN);
	SDL_Keycode sym ;if(info) sym=info->keysym.sym;
	Uint16 mod ;if(info) mod=info->keysym.mod;
	//if(!mod&KMOD_SHIFT);
	//if(sym==SDLK_RETURN);
	if(!down&&(input_mask&1))
{		setup_comm(1);if(fd>=0)
{			comm_key(3,sym,mod);write_1(1);
}}	if(!down||(down&&mod_check(mod,1,0,0,0)))
{		if(sym==SDLK_0)scroll_e=!down?-1:0;else if(sym==SDLK_1)scroll_e=!down?-1:1;else if(sym==SDLK_2)scroll_e=!down?-1:2;else if(sym==SDLK_3)scroll_e=!down?-1:3;
}	if(down);else return;
	if(builtin_key/*or no ret.*/)
{		int oldfzoom=fzoom;
		if(builtin_key==2)
{			if((sym==SDLK_PAGEUP||sym==SDLK_PAGEDOWN)&&mod_check(mod,0,0,0,0))goto key1;
			goto key_end;
}		if(sym==SDLK_HOME&&mod_check(mod,0,0,0,0)){show_targ1=(show_targ1+1)%2;redraw=1;}
		else if(sym==SDLK_q&&mod_check(mod,2,0,0,0))
{			if(mod&KMOD_CTRL)setup_comm(2);
			else app_done=1;
}		else if(sym==SDLK_g&&mod_check(mod,0,0,0,0)){show_grid=(show_grid+1)%2;redraw=1;}
		else if(sym==SDLK_c&&mod_check(mod,0,0,2,0))
{			if(mod&KMOD_SHIFT)script2(win_abs.w/2-prev_x,win_abs.h/2-prev_y);
			else script2(prev_x-win_abs.w/2,prev_y-win_abs.h/2);
}		else if((sym==SDLK_PAGEUP||sym==SDLK_PAGEDOWN)&&mod_check(mod,0,0,0,0))
{			key1:;scroll_x=prev_x;scroll_y=prev_y;
			int val[]={win_abs.w/2-prev_x,win_abs.h/2-prev_y};
			if(iabs(val[0])>iabs(val[1]))
{				if(iabs(val[0])-iabs(val[1])<iabs(val[1]))val[1]=((val[1]>0)-(val[1]<0))*iabs(val[0]);else val[1]=0;
}			else
{				if(iabs(val[1])-iabs(val[0])<iabs(val[0]))val[0]=((val[0]>0)-(val[0]<0))*iabs(val[1]);else val[0]=0;
}			if(sym==SDLK_PAGEUP)script2(val[0],val[1]);
			else script2(-val[0],-val[1]);
}		else if(sym==SDLK_z&&mod_check(mod,0,0,0,0))
{			if(win_abs.h*iabs(prev_x-win_abs.w/2)>win_abs.w*iabs(prev_y-win_abs.h/2))fzoom=oldfzoom*win_abs.w/(2*iabs(prev_x-win_abs.w/2));
			else fzoom=oldfzoom*win_abs.h/(2*iabs(prev_y-win_abs.h/2));
}		else if(sym==SDLK_y&&mod_check(mod,0,0,0,0))
{			if(win_abs.h*iabs(prev_x-win_abs.w/2)>win_abs.w*iabs(prev_y-win_abs.h/2))fzoom=oldfzoom*(2*iabs(prev_x-win_abs.w/2))/win_abs.w;
			else fzoom=oldfzoom*(2*iabs(prev_y-win_abs.h/2))/win_abs.h;
}		else if(sym==SDLK_x&&mod_check(mod,0,0,0,0))
{			win_coord_n=(win_coord_n+1)%2;
}		if(/*mod&KMOD_CTRL*/mod_check(mod,1,0,0,0))
{			if(sym==SDLK_EQUALS)fzoom=min(oldfzoom/10*10+10,(unsigned int)-1/2);
			else if(sym==SDLK_MINUS)fzoom=max(1,oldfzoom/10*10-10);
			else if(sym==SDLK_0)fzoom=100;
			else if(sym==SDLK_9){if(dest_bound.h!=0)fzoom=win_abs.h*100/dest_bound.h;}
			else if(sym==SDLK_8){if(dest_bound.w!=0)fzoom=win_abs.w*100/dest_bound.w;};
}		if(fzoom!=oldfzoom)
{			coord_arg=-1;while(coord_arg</*1*/0)
{				coord_arg+=1;
				win_coord1.x=win_coord1.x*fzoom/oldfzoom;
				win_coord1.y=win_coord1.y*fzoom/oldfzoom;
}			redraw=1;//script2(0,0);
}		key_end:;
}	setup_comm(1);if(fd>=0)
{		comm_key(3,sym,mod);if(input_mask&1)write_1(0)
;
}}void set_pr_flag(signed char field)
{	if(0)
{		char *res=getenv("pr_flag");if(res)pr_flag=strtol(res,NULL,0/*base*/);else pr_flag=0;
}	if(1)
{		char *res=getenv("pr_flag");if(res)
{			char *res2=res,*res2_f=NULL;while(res2[0]){if(res2[0]=='.')break;res2+=1;};
			if(field==1)res2=res2_f=strndup(res,res2-res);
			else if(field==2)
{				if(res2[0]=='.')res2=res2+1;else res2=res;
}			pr_flag=strtol(res2,NULL,0/*base*/);free(res2_f);
}		else pr_flag=0;
}}void main_win(int w,int h,char op)
{	redraw=1;if(window)
{		if(op==2)SDL_SetWindowSize(window,w,h);
}	else
{		win_coord1.x=-w/2;win_coord1.y=-h/2;
		win_coord[1].x=-w/2;win_coord[1].y=-h/2;
		scroll_x=w/2;scroll_y=h;
		//sdl(0,CreateWindowAndRenderer(w, h, 0, &window, &renderer);
		window=sdl(1,CreateWindow,getenv("title"), SDL_WINDOWPOS_UNDEFINED,SDL_WINDOWPOS_UNDEFINED, w,h, SDL_WINDOW_RESIZABLE);
		//SDL_SetWindowPosition(window,0,40);
		renderer = sdl(1,CreateRenderer,window,-1,0/*SDL_RENDERER_SOFTWARE/_ACCELERATED*//*|SDL_RENDERER_TARGETTEXTURE*/);
		SDL_SetRenderDrawBlendMode(renderer,SDL_BLENDMODE_BLEND);
		//SDL_Rect ClipRect;set_rect(ClipRect,0,0,400,400);SDL_RenderSetClipRect(renderer,&ClipRect);
}}int main(int argc, char **argv)
{	main_argc=argc;main_argv=argv;set_pr_flag(1);
	SDL_Event ev
;
	SDL_LogSetPriority(SDL_LOG_CATEGORY_APPLICATION, SDL_LOG_PRIORITY_INFO);
	sdl(0,Init,SDL_INIT_EVENTS/*|SDL_INIT_NOPARACHUTE*/);// Event Handling, File I/O, and Threading subsystems are initialized by default;
	SDL_bool did_set=SDL_SetHint(SDL_HINT_RENDER_DRIVER,"software");
	if(did_set)
{		printf("set software render hint\n");fflush(stdout);
}	if(1)
{		///*Uint8*/SDL_EventState(SDL_WINDOWEVENT,SDL_IGNORE/*SDL_QUERY*/);
		/*Uint8*/SDL_EventState(SDL_MOUSEMOTION,SDL_IGNORE/*SDL_QUERY*/);
		/*Uint8*/SDL_EventState(SDL_KEYMAPCHANGED,SDL_IGNORE/*SDL_QUERY*/)
;
}	/*main_win(640,480,0)*/
;
	//script1(0,0);
	setup_comm(0);
	int count1=0;while(1)
{		char flag1=0;
		while(SDL_PollEvent(&ev))
{			ev_lo:;
			if(ev.type==SDL_QUIT)app_done=1;
			else if(ev.type!=0x200&&ev.type!=0x400&&ev.type!=0x304)
{				flag1=1;//dprintf(2,"ev %x\n",ev.type);
}			CheckWEvent(&ev);
			CheckDrEvent(&ev);
			CheckBEvent(&ev);
			CheckKEvent(&ev);
}		if(!window)while(check_comm()){flag1=1;if(!window)main_win(640,480,0);}
		else while(check_comm())flag1=1;
		if(redraw)
{			refresh=1;script2(0,0);draw_all(0);redraw=0;
}		if(refresh)
{			SDL_RenderPresent(renderer);refresh=0;
}		if(app_done)break;else if(flag1==0){if(count1>=50*120/*2m*/)
{			usleep(1000000/*1000ms*/);if(1&&SDL_WaitEvent(&ev))goto ev_lo;
}		else{usleep(20000/*20ms*/);count1+=1;}}else count1=0;
}	setup_comm(3);SDL_Quit()/*Xserver hung multiple times without this*/;
	return 0;
}